/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb  6 23:53:38 2002 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.lisp;

import junit.framework.*;

import ix.util.Debug;
import ix.util.TestUtil;

/**
 * Symbol test cases.
 */
public class SymbolTest extends TestCase {

    public SymbolTest(String name) {
	super(name);
    }

    // /\/: Maybe reset obtable after each test.

    public void testSelfEq() {
	assertSame(Symbol.intern("snore"), Symbol.intern("snore"));
    }

    public void testInternFactory() {
	assertTrue(Symbol.intern("apple") instanceof Symbol);
	assertTrue(Symbol.intern(":apple") instanceof Keyword);
	assertTrue(Symbol.intern("?apple") instanceof ItemVar);
	assertTrue(Keyword.intern(":apple") instanceof Keyword);
    }

    public void testSerialization() {
	Symbol apple = Symbol.intern("apple");
	try {
	    assertSame("serialize and back",
		       apple,
		       TestUtil.serializeAndBack(apple));
	}
	catch (Exception e) {
	    Debug.noteException(e);
	    fail("Exception " + e);
	}
    }

}

