/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import junit.framework.*;

/**
 * Tests that the root context is as it should be.
 */
public class RootContextTest extends TestCase {

    // These tests should not do anything that needs a setUp() or tearDown(),
    // and contexts should be in their initial state (e.g. the rootContext
    // should have no children).

    public RootContextTest(String name) {
	super(name);
    }

    public void testRooTContextExists() {
	assertTrue(Context.rootContext != null);
    }

    public void testRootContext() {
	assertTrue(Context.rootContext instanceof Context);
	assertEquals(0, Context.rootContext.getNumber());
	assertTrue(Context.rootContext.getParent() == null);
	assertTrue(Context.rootContext.getChildren().isEmpty());
    }

    public void testRootContextFromContextNumber() {
	assertSame(Context.rootContext, Context.getContext(0));
    }

}
