/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Feb 22 17:39:35 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.*;

/**
 * Test cases for StableHashMaps.
 */
public class StableHashMapTest extends AbstractMapTest {

    public StableHashMapTest(String name) {
	super(name);
    }

    protected Map makeMap() {
	return new StableHashMap();
    }

    protected Map makeMap(Map m) {
	return new StableHashMap(m);
    }

    public void testEntryOrder() {
	Map m = makeMap();
	// apple -> red, grass -> green
	m.put("apple", "red");
	m.put("grass", "green");
	assertEquals(Lisp.list("apple", "grass"),
		     LList.newLList(m.keySet()));
	assertEquals(Lisp.list("red", "green"),
		     LList.newLList(m.values()));
	// snow -> white
	m.put("snow", "white");
	assertEquals(Lisp.list("apple", "grass", "snow"),
		     LList.newLList(m.keySet()));
	assertEquals(Lisp.list("red", "green", "white"),
		     LList.newLList(m.values()));
	// grass -> yellow
	m.put("grass", "yellow");
	assertEquals(Lisp.list("apple", "grass", "snow"),
		     LList.newLList(m.keySet()));
	assertEquals(Lisp.list("red", "yellow", "white"),
		     LList.newLList(m.values()));
    }

}
