/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun 16 22:33:39 2008 by Jeff Dalton
 * Copyright: (c) 2001 - 2004, AIAI, University of Edinburgh
 */

package ix.util;

import junit.framework.*;
import ix.util.Parameters;

/**
 * Test suite that includes all tests for the ix.util package and subpackages.
 */
public class AllTests {

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	junit.textui.TestRunner.run(suite());
    }

    public static Test suite () {
	TestSuite suite = new TestSuite("ix.util tests");

	// Tests for this package.
	suite.addTest(new TestSuite(SeqTest.class));
	suite.addTest(new TestSuite(HashSetTest.class));
	suite.addTest(new TestSuite(HashMapTest.class));
	suite.addTest(new TestSuite(StableHashMapTest.class));
	suite.addTest(new TestSuite(LinkedListTest.class));
	suite.addTest(new TestSuite(LinkedListListIteratorTest.class));
	suite.addTest(new TestSuite(StructuralEqualityTest.class));
	suite.addTest(new TestSuite(EnumeratedValueTest.class));
	suite.addTest(new TestSuite(ISODateFormatTest.class));
	suite.addTest(new TestSuite(StringsTest.class));
	suite.addTest(new TestSuite(CollectTest.class));
	suite.addTest(new TestSuite(GraphsTest.class));
	suite.addTest(new TestSuite(DAGTransitiveClosureTest.class));
	suite.addTest(new TestSuite(FullTransitiveClosureTest.class));

	// Subpackages
	if (Parameters.getBoolean("recursive", true)) {
	    suite.addTest(ix.util.lisp.AllTests.suite());
	    suite.addTest(ix.util.match.AllTests.suite());
	    suite.addTest(ix.util.context.AllTests.suite());
	    suite.addTest(ix.util.xml.AllTests.suite());
	}

	return suite;
    }

}
