/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Aug 19 03:34:28 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

import junit.framework.*;

import ix.util.lisp.*;

/**
 * Provides utilities for graph tests.
 */
public abstract class AbstractGraphsTest extends TestCase {

    // We use TreeSets to put things in a nice order when comparing
    // as sets.  We compare as sets when no particular order is
    // required.

    public AbstractGraphsTest(String name) {
	super(name);
    }

    protected Set readSet(String elements) {
	return new TreeSet(Lisp.elementsFromString(elements));
    }

    protected LList readMapLList(String source) {
	return (LList)Lisp.readFromString(source);
    }

    protected void checkMap(LList expected, Map m) {
	LList keys = expected.alistKeys();
	assertEquals("all keys",
		     new TreeSet(keys),
		     new TreeSet(m.keySet()));
	for (Iterator i = keys.iterator(); i.hasNext();) {
	    Object k = i.next();
	    LList expect = (LList)expected.alistValue(k);
	    assertEquals("values for " + k,
			 new TreeSet(expect),
			 new TreeSet((Collection)m.get(k)));
	}
    }

    protected void checkMapStrictly(LList expected, Map m) {
	// Here we don't use a set for comparing the value collections.
	LList keys = expected.alistKeys();
	assertEquals("all keys",
		     new TreeSet(keys),
		     new TreeSet(m.keySet()));
	for (Iterator i = keys.iterator(); i.hasNext();) {
	    Object k = i.next();
	    LList expect = (LList)expected.alistValue(k);
	    assertEquals("values for " + k,
			 expect,
			 LList.newLList((Collection)m.get(k)));
	}
    }

    protected LList readGraphLList(String source) {
	LList alist = (LList)Lisp.readFromString(source);
	// Find all vertices mentioned in the alist, either
	// as keys or among the values.
	LListCollector all = new LListCollector();
	alist.walkTree(all.elementAdder());
	// Add an empty successor list for all vertices that
	// were not given a value by the alist.
	LListCollector result = new LListCollector(alist);
	for (Iterator i = all.iterator(); i.hasNext();) {
	    Object v = i.next();
	    if (alist.alistValue(v) == null)
		result.add(Lisp.list(v, Lisp.NIL));
	}
	return result.contents();
    }

    protected void checkGraph(LList expected, DirectedGraph g) {
	LList vertices = expected.alistKeys();
	assertEquals("all vertices",
		     new TreeSet(vertices),
		     new TreeSet(g.getAllNodes()));
	for (Iterator i = vertices.iterator(); i.hasNext();) {
	    Object v = i.next();
	    LList expect = (LList)expected.alistValue(v);
	    assertEquals("successors for " + v,
			 new TreeSet(expect),
			 new TreeSet(g.getSuccessors(v)));
	}
    }

}
