;;; Simple, variable-free tests of "use" constraints
;;; Author: Jeff Dalton
;;; Updated: Sun Jun 17 04:44:23 2007 by Jeff Dalton

;;; Test1 has two solutions, one for each order in which the
;;; "use-apple" activities can occur.  Test2 has only one solution
;;; because no ordering constraints are needed.  The later tests are
;;; variations with more activities.

(refinement test1 (test1) ; 2 solutions
  (nodes
    (1 (use-apple))
    (2 (use-apple))))

(refinement test2 (test2) ; 1 solution
  (nodes
    (1 (use-apple))
    (2 (use-pear))))

(refinement test3 (test3) ; 6 solutions
  (nodes
    (1 (use-apple))
    (2 (use-apple))
    (3 (use-apple))))

(refinement test4 (test4) ; 2 soltions, like test1
  (nodes
    (1 (use-apple))
    (2 (use-apple))
    (3 (use-pear))))

(refinement test5 (test5) ; 6 solutions, like test3
  (nodes
    (1 (use-apple))
    (2 (use-apple))
    (3 (use-pear))
    (4 (use-apple))))

(refinement use-apple (use-apple)
  (constraints
    (resource use (apple) = true)))

(refinement use-pear (use-pear)
  (constraints
    (resource use (pear) = true)))

;;; End
