;;; This is like simple-service-composition-1, except that it
;;; has a service that generates the plain_text doc rather than
;;; having it as part of the initial state.

(refinement test1 (test1)
  ;; Just needs to invoke text_gen.
  (variables ?doc)
  (constraints
    (world-state condition (type ?doc) = plain_text)))

(refinement test2 (test2)
  ;; Needs to put the output of text_gen through text_markup.
  (variables ?doc)
  (constraints
    (world-state condition (type ?doc) = html)))

(refinement test3 (test3)
  ;; Needs to put the output of text_gen through text_markup,
  ;; but also needs some plain_text.  Will text_gen be invoked
  ;; twice, or only once?
  (variables ?marked-up-doc ?plain-doc)
  (constraints
    (world-state condition (type ?marked-up-doc) = html)
    (world-state condition (type ?plain-doc) = plain_text)))

; As of 27 April 2004, both test3 and test4 had one invocation
; of text_gen in their first plan and two in their second.

(refinement test4 (test4)
  ;; Like test3, but with the conditions in the opposite order.
  (variables ?marked-up-doc ?plain-doc)
  (constraints
    (world-state condition (type ?plain-doc) = plain_text)
    (world-state condition (type ?marked-up-doc) = html)))

(refinement text_gen (text_gen to ?text)
  (variables ?text)
  (constraints
    (world-state effect (type ?text) = plain_text))
  (annotations
    (output-objects = ((?text plain_text)))))
      
(refinement text_markup (text_markup ?doc to ?html)
  (variables ?doc ?html)
  (constraints
    (world-state condition (type ?doc) = plain_text)
    (world-state effect (type ?html) = html))
  (annotations
    (input-objects = ((?doc plain_text)))
    (output-objects = ((?html html)))))

;;; End
