;;; Simple tests of "duration" constraints.

;;; Test1 repeats 0 or more times an activity that takes 1 hour,
;;; inside an activity that sets a time limit by having a max
;;; duration of just under 3 hours.  There are therefore three plans.

(refinement test1 (test1)
  (nodes
    (1 (repeat something)))
  (constraints
    (temporal duration self = PT1H .. PT2H59M59S))) ; .. not quite 3 hrs

(refinement repeat (repeat something)
  (nodes
    (1 (do something))
    (2 (repeat something)))
  (orderings
    (1 2)))

(refinement end-repeat (repeat something)
   )

(refinement do (do something)
  (constraints
    (temporal duration self = PT1H .. PT1H)))

;;; Test2 sets up so short a time limit around an activity that
;;; it has no solutions.

(refinement test2 (test2)
  (nodes
    (1 (do something))) ; expansion of this node should fail
  (constraints
    (temporal duration self = PT1M .. PT10M)))

;;; End

