;;; Missionaries and cannibals

;;; This is based on the O-Plan domain mission-with-only-compute.tf

(annotations
  (compute-support-code = "test-domains/missionary-support.lsp"))

;;; Tasks

(refinement mc-problem (mc-problem)
  (nodes
    (1 (finish))))

(refinement start (start)
  (variables ?path)
  (constraints
    (world-state effect (state) = (?path (left 3 3 0 0)))))

(refinement finish (finish)
  (constraints
    (world-state condition (state) = (() (right 0 0 3 3)))))

;;; Moving people

;;; Movements differ only in the numbers moved.

(refinement move-m-c (move ?pre-state ?move)
  (variables ?new-path ?new-state ?pre-path ?pre-state ?move)
  (constraints
    (world-state effect (state) = (?new-path ?new-state))
    (compute (equal ?new-state (left 3 3 0 0)) = false)
    (compute multiple-answer (identity ((2 0) (0 2) (1 0) (0 1) (1 1)))
	     = ?move)
    (compute (apply next-state ?new-state ?move) = ?pre-state)
    (compute (is-state ?pre-state) = true)
    (compute (contains ?new-path ?pre-state) = false)
    (compute (cons ?new-state ?new-path) = ?pre-path)
    (world-state condition (state) = (?pre-path ?pre-state))))

;;; End
