;;; Tests cases where an achievable condition can be satisfied
;;; on its own but not in a way that satisfies some other condition.

;;; Assumes initial state:
;;;
;;;   number = 0
;;;   name = a
;;;   ok b = true
;;;   ok c = true
;;;

(refinement test1 (test1)
  (variables ?x)
  (constraints
    (world-state condition (number) = ?x)
    (compute (> ?x 0) = true)))

(refinement test2 (test2)
  (variables ?x)
  (constraints
    (world-state condition (name) = ?x)
    (compute (equal ?x a) = false)))

(refinement test3 (test3)
  (variables ?x)
  (constraints
    (world-state condition (name) = ?x)
    (world-state condition (ok ?x) = true)))

(refinement test4 (test4)
  (variables ?x)
  (constraints
    (world-state condition (ok ?x) = true)
    (world-state condition (name) = ?x)))

(refinement test5 (test5)
  (variables ?x)
  (nodes
    (1 (check-name ?x)))
  (constraints
    (world-state condition (name) = ?x)))

(refinement check-name (check-name ?name)
  (variables ?name)
  (constraints
    (world-state condition (ok ?name) = true)))

(refinement set-number (set-number-to ?x)
  (variables ?x)
  (constraints
    (compute (- 7 6) = ?x)
    (world-state effect (number) = ?x)))

(refinement set-name (set-name-to b)
  (constraints
    (world-state effect (name) = b)))

;;; End
