;;; This is based on achieve-limitation-test-1 but uses "achieve" subnodes
;;; rather than conditions.

;;; N.B. The duplicate filter is only in I-Plan, not the planning
;;; algorithm, and so will not be there when auto-testing.

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1)
  ;; No solution, because the "achieve" subnodes of 3 cannot
  ;; execute before 2.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  (orderings
    (1 2 3)))

(refinement test2 (test2)
  ;; Only one solution, modulo duplicates.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  ;; This time 3 still has to start after 1, but not after 2.
  ;; It can finish after 2, therefore so can the subnode that
  ;; takes a picture of the new decorations.
  (orderings
    (1 (2 3))))

(refinement test3 (test3)
  ;; Only one solution, modulo duplicates.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures)))
  ;; 3 can happen whenever it wants relative to 1 and 2.
  (orderings
    (1 2)))

(refinement test4 (test4)
  ;; No solution.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures-after new)))
  ;; The orderings let 3 happen whenever it wants relative to 1 and 2,
  ;; but a constraint means that it has to start after 2 finishes,
  ;; and so its subnodes must all be after 2.
  (orderings
    (1 2)))

(refinement test5 (test5)
  ;; Only one solution, modulo duplicates.
  (nodes
    (1 (set-decoration old))
    (2 (set-decoration new))
    (3 (take-pictures-after old)))
  ;; The orderings let 3 happen whenever it wants relative to 1 and 2,
  ;; but a constraint means that it has to start after 1 finishes and
  ;; before 2 starts.
  (orderings
    (1 2)))

(refinement set-decoration (set-decoration ?value)
  (variables ?value)
  (constraints
    (world-state effect (decoration) = ?value))
  (annotations
    ;; Keep this refinement from being used to achieve a condition.
    (use-for-world-state-effects = :none)))

(refinement take-pictures (take-pictures)
  (nodes
    (1 (achieve (have-pictures-of old)))
    (2 (achieve (have-pictures-of new)))))

(refinement snap (achieve (have-pictures-of ?what))
  (variables ?what)
  (constraints
    (world-state condition (decoration) = ?what)
    (world-state effect (have-pictures-of ?what) = true)))

(refinement take-pictures-after (take-pictures-after ?value)
  (variables ?value)
  (nodes
    (1 (achieve (have-pictures-of old)))
    (2 (achieve (have-pictures-of new))))
  (constraints
    (world-state condition (decoration) = ?value)))

;;; End
