;;; Pure HTN
;;; Everything sequential

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1)
  (nodes
    (0 (setup-ca-b))
    (1 (require-abc-seq)))
  (orderings
    (0 1)))

(refinement test2 (test2)
  (nodes
    (0 (setup-cba))
    (1 (require-abc-seq)))
  (orderings
    (0 1)))

(refinement test3 (test3)
  (nodes
    (0 (setup-ab-c))
    (1 (require-abc-seq)))
  (orderings
    (0 1)))

(refinement setup-ca-b (setup-ca-b)
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c a) = true)
    (world-state effect (on a table) = true)
    (world-state effect (cleartop b) = true)
    (world-state effect (on b table) = true)))

(refinement setup-ab-c (setup-ab-c)
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop a) = true)
    (world-state effect (on a b) = true)
    (world-state effect (on b table) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c table) = true)))

(refinement setup-cba (setup-cba)
  (constraints
    (world-state effect (block a) = true)
    (world-state effect (block b) = true)
    (world-state effect (block c) = true)
    (world-state effect (cleartop c) = true)
    (world-state effect (on c b) = true)
    (world-state effect (on b a) = true)
    (world-state effect (on a table) = true)))

(refinement require-abc-seq (require-abc-seq)
  (nodes
    (1 (achieve (on c table)))
    (2 (achieve (on b c)))
    (3 (achieve (on a b))))
  (orderings
    (1 2 3)))

;;; Achieving block on table

(refinement table-no-op (achieve (on ?block table))
  (variables ?block)
  (constraints
    ;; See if it's already on the table.
    (world-state condition (block ?block) = true)
    (world-state condition (on ?block table) = true)))

(refinement table (achieve (on ?block table))
  (variables ?block ?support)
  (nodes
    (1 (achieve (cleartop ?block)))
    (2 (move-to-table ?block)))
  (orderings
    (1 2))
  (constraints
    ;; See if it's on a block and so needs to be moved.
    (world-state condition (block ?block) = true)
    (world-state condition (block ?support) = true)
    (world-state condition (on ?block ?support) = true)))

;;; Achieving block on block

(refinement move-no-op (achieve (on ?block ?to))
  (variables ?block ?to)
  (constraints
    ;; See if it's already there.
    (world-state condition (block ?block) = true)
    (world-state condition (block ?to) = true)
    (world-state condition (on ?block ?to) = true)))

(refinement move (achieve (on ?block ?to))
  (variables ?block ?to)
  (nodes
    (1 (achieve (cleartop ?block)))
    (2 (achieve (cleartop ?to)))
    (3 (move ?block ?to)))
  (orderings
    ;; Could be ((1 2) 3), but in this file we want everything sequential.
    (1 2 3))
  (constraints
    ;; /\/: We can't yet require that the block not already be
    ;; where we want it.  [We can now with compute.  Done 24 May 08.]
    (world-state condition (block ?block) = true)
    (world-state condition (block ?to) = true)
    (world-state condition (on ?block ?support) = true)
    (compute (equal ?to ?support) = false)))

;;; Achieving cleartop

(refinement cleartop-no-op (achieve (cleartop ?block))
  (variables ?block)
  (constraints
    ;; See if its top is already clear.
    (world-state condition (block ?block) = true)
    (world-state condition (cleartop ?block) = true)))

(refinement cleartop (achieve (cleartop ?block))
  (variables ?block ?higher)
  (nodes
    (1 (achieve (cleartop ?higher)))
    (2 (move-to-table ?higher)))
  (orderings
    (1 2))
  (constraints
    ;; See if something is on top of the block so that we
    ;; need to move it off.
    (world-state condition (block ?block) = true)
    (world-state condition (block ?higher) = true)
    (world-state condition (on ?higher ?block) = true)))

;;; Movement primitives

(refinement move-to-table (move-to-table ?block)
  (variables ?block ?support)
  ;; We allow ?support to be the table, because higher-level
  ;; refinements already ensure that it's a block. /\/
  (constraints
    (world-state condition (block ?block) = true)
    (world-state condition (cleartop ?block) = true)
    (world-state condition (on ?block ?support) = true)
    ;; (world-state condition (block ?support) = true)
    (world-state effect (on ?block table) = true)
    (world-state effect (on ?block ?support) = false)
    (world-state effect (cleartop ?support) = true)))

(refinement move-to-block (move ?block ?to)
  (variables ?block ?to ?support)
  ;; ?support might be the table
  (constraints
    (world-state condition (block ?block) = true)
    (world-state condition (cleartop ?block) = true)
    (world-state condition (on ?block ?support) = true)
    (world-state condition (block ?to) = true)
    (world-state condition (cleartop ?to) = true)
    (world-state effect (on ?block ?to) = true)
    (world-state effect (on ?block ?support) = false)
    (world-state effect (cleartop ?to) = false)
    (world-state effect (cleartop ?support) = true)))

;;; End

