;;; Binding-constraint test
;;; Author: Jeff Dalton
;;; Updated: Mon Apr  4 13:51:48 2005 by Jeff Dalton

;;; Tests whether constraints from several different matches against
;;; the world-state can collectively determine a value.  There is
;;; only one object that is yellow, round, and a fruit.

(annotations
  (achievable-world-state-conditions = :none))

(refinement test1 (test1)
  (variables ?object)
  (nodes
    (0 (setup))
    (1 (require-colour ?object yellow)))
  (orderings
    (0 1)))

(refinement setup (setup)
  (constraints
    (world-state effect (colour lemon) = yellow)
    (world-state effect (colour sun) = yellow)
    (world-state effect (colour banana) = yellow)
    (world-state effect (type lemon) = fruit)
    (world-state effect (type sun) = star)
    (world-state effect (type banana) = fruit)
    (world-state effect (shape lemon) = round)
    (world-state effect (shape sun) = round)
    (world-state effect (shape banana) = banana-shaped)))

(refinement require-colour (require-colour ?object ?colour)
  (variables ?object ?colour)
  (nodes
    (1 (require-type ?object fruit)))
  (constraints
    (world-state condition (colour ?object) = ?colour)))

(refinement require-type (require-type ?object ?type)
  (variables ?object ?type)
  (nodes
    (1 (require-shape ?object round)))
  (constraints
    (world-state condition (type ?object) = ?type)))

(refinement require-shape (require-shape ?object ?shape)
  (variables ?object ?shape)
  (constraints
    (world-state condition (shape ?object) = ?shape)))

;;; For test2, we put all of the nodes in at once.

(refinement test2 (test2)
  (variables ?object)
  (nodes
    (1 (setup))
    (2 (require (colour ?object) = yellow))
    (3 (require (type ?object) = fruit))
    (4 (require (shape ?object) = round)))
  (orderings
    (1 2 3 4)))

(refinement require (require (?prop ?obj) = ?value)
  (variables ?prop ?obj ?value)
  (constraints
    (world-state condition (?prop ?obj) = ?value)))

;;; Test3 has the world state in the opposite order

(refinement test3 (test3)
  (variables ?object)
  (nodes
    (1 (reverse-setup))
    (2 (require (colour ?object) = yellow))
    (3 (require (type ?object) = fruit))
    (4 (require (shape ?object) = round)))
  (orderings
    (1 2 3 4)))

(refinement reverse-setup (reverse-setup)
  (constraints
    (world-state effect (shape banana) = banana-shaped)
    (world-state effect (shape sun) = round)
    (world-state effect (shape lemon) = round)
    (world-state effect (type banana) = fruit)
    (world-state effect (type sun) = star)
    (world-state effect (type lemon) = fruit)
    (world-state effect (colour banana) = yellow)
    (world-state effect (colour sun) = yellow)
    (world-state effect (colour lemon) = yellow)))

;;; Test4 puts the nodes in the opposite order.  This finds a value
;;; sooner, because there's only one round fruit.

(refinement test4 (test4)
  (variables ?object)
  (nodes
    (1 (setup))
    (2 (require (colour ?object) = yellow))
    (3 (require (type ?object) = fruit))
    (4 (require (shape ?object) = round)))
  (orderings
    (1 4 3 2)))

;;; For test5, we go down to two values rather than one.

(refinement test5 (test5)
  (variables ?object)
  (nodes
    (1 (setup))
    (2 (require (colour ?object) = yellow))
    (3 (require (type ?object) = fruit)))
  (orderings
    (1 2 3)))

;;; End
