/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Apr 28 15:29:09 2003 by Jeff Dalton
 * Copyright: (c) 2001, AIAI, University of Edinburgh
 */

package ix.util.xml;

import java.util.*;

import java.io.IOException;
import java.io.StringReader;
import java.io.File;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.*;
import javax.xml.transform.dom.*;

// Imports for using JDOM
// import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Attribute;
import org.jdom.Namespace;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

import org.jdom.transform.JDOMSource;
import org.jdom.transform.JDOMResult;

import ix.util.reflect.*;
import ix.util.lisp.*;
import ix.util.*;

/**
 * A class containing useful static XSLT-related utilities.
 */

public class Xform {

    private Xform() { }		// don't allow instantiation

    public static Document transform(Document in, String stylesheet)
	   throws JDOMException {
	try {
	    Transformer transformer = TransformerFactory.newInstance()
		.newTransformer(new StreamSource(stylesheet));

	    JDOMResult out = new JDOMResult();
	    transformer.transform(new JDOMSource(in), out);
	    return out.getDocument();
	}
	catch (TransformerException e) {
	    throw new JDOMException("XSLT Trandformation failed", e);
	}
    }

    static String[] Features = {
	JDOMSource.JDOM_FEATURE,
	SAXSource.FEATURE,

	JDOMResult.JDOM_FEATURE,
	SAXResult.FEATURE
    };

    public static void checkTFactory(TransformerFactory tfactory) {
	Debug.noteln("Transformer factory", tfactory);
	Debug.noteln("Transformer factory class", 
		     tfactory.getClass().getName());
    }

    /**
     * For testing
     */
    public static void main(String[] argv) throws Exception {
	if (argv.length < 2) {
	    System.out.println("Args are: stylesheet file-to-transform");
	    return;
	}
	String stylesheet = argv[0];
	String filename = argv[1];
	Document doc = XML.parseXML(new File(filename));
	Document result = transform(doc, stylesheet);
	new XMLOutputter().output(result, System.out);
    }
 
}
