/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Sep 19 04:22:00 2004 by Jeff Dalton
 * Copyright: (c) 2002, 2003, AIAI, University of Edinburgh
 */

package ix.util.xml;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.*;

import org.jdom.Document;

import ix.icore.IXAgent;

import ix.util.*;
import ix.util.lisp.*;

/** 
 * An XML tree editor as a standalone application main program
 * and I-X agent.
 *
 * @see XMLTreeEditFrame
 * @see XMLTreeEditPanel
 */

public class XMLTreeEditor extends IXAgent {

    protected XMLTreeEditFrame frame;

    protected MessageFrame messageFrame;

    public XMLTreeEditor() {
	displayName = "I-X XML Tree Editor";

	// Change Icons used for "one-touch" expand / collapse operation.
	// It appears that we have to do this globally.  /\/
	UIManager.put("Tree.expandedIcon",
		      Util.resourceImageIcon("ix-symbol-fold.gif"));
	UIManager.put("Tree.collapsedIcon",
		      Util.resourceImageIcon("ix-symbol-unfold.gif"));

    }

    /**
     * Main program.
     */
    public static void main(String[] argv) {

	Util.printGreeting("XML Tree Editor");

	new XMLTreeEditor().mainStartup(argv);

    }

    /**
     * Command-line argument processing.  There are at present no
     * command-line arguments beyond those used by all IXAgents.
     *
     * @see ix.icore.IXAgent#processCommandLineArguments()
     */
    protected void processCommandLineArguments() {
	super.processCommandLineArguments();
    }

    /**
     * Completes setup and initialization.
     */
    public void startup() {
	Util.swingAndWait(new Runnable() {
	    public void run() {
		frame = new XMLTreeEditFrame(XMLTreeEditor.this, displayName);
		frame.setVisible(true);
		String resource = Parameters.getParameter("document");
		if (resource != null) {
		    Document doc = XML.readDocument(resource);
		    frame.editDocument(doc);
		}
	    }
	});
    }

    public void handleInput(IPC.InputMessage message) {
	if (messageFrame == null) {
	    messageFrame = new MessageFrame(this);
	}
	messageFrame.addMessage(message);
	messageFrame.setVisible(true);
    }

    public void addTool(ix.iface.util.ToolController tc) {
	frame.addTool(tc);
    }

    /**
     * An editor frame for displaying any messages received by
     * a tree editor acting as an I-X agent.
     */
    protected class MessageFrame extends XMLTreeEditFrame {
	MessageFrame(IXAgent agent) {
	    super(agent, displayName + " Messages");
	    editDocument(XML.parseXML("<messages-received />"));
	    pack();
	    editPanel.hideTemplates();
	}
	void addMessage(IPC.InputMessage message) {
	    Object contents = message.getContents();
	    editPanel.addRootChild(XML.objectToDocument(contents));
	}
    }

}
