/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jun 16 01:36:29 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.annotation.*;

/**
 * Annotation for listing fields that should not be included in
 * the visible syntax for a class.  This means a subclass needn't
 * show everything it inherits.  The value is a String array of
 * field names.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
@Documented
public @interface HiddenFields {

    String[] value();

}
