/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun 26 02:54:27 2008 by Jeff Dalton
 * Copyright: (c) 2003, 2008, AIAI, University of Edinburgh
 */

package ix.util.reflect;

import java.lang.reflect.*;
import java.util.*;

import ix.util.*;

/**
 * Maps an external or internal (Java) name to a {@link FieldDescr}.
 * Used in {@link ClassDescr}s.
 */
public class FieldMap {

    protected Map<String,FieldDescr> javaNameToField =
	new HashMap<String,FieldDescr>();

    protected Map<String,FieldDescr> externalNameToField =
	new HashMap<String,FieldDescr>();

    protected List<FieldDescr> fields =
	new LinkedList<FieldDescr>();

    public FieldMap() {}

    public void add(FieldDescr fd) {
	javaNameToField.put(fd.getName(), fd);
	externalNameToField.put(fd.getExternalName(),fd);
	fields.add(fd);
    }

    public void remove(FieldDescr fd) {
	javaNameToField.remove(fd.getName());
	externalNameToField.remove(fd.getExternalName());
	fields.remove(fd);
    }

    public void rename(String from, String to, ClassSyntax syntax) {
	FieldDescr fd = fieldForName(from);
	remove(fd);
	fd.renameTo(to, syntax.externalNameForField(to));
	add(fd);
    }

    FieldDescr fieldForName(String name) {
	return (FieldDescr)javaNameToField.get(name);
    }

    FieldDescr fieldForExternalName(String name) {
	return (FieldDescr)externalNameToField.get(name);
    }

    List<FieldDescr> getFields() {
	return fields;
    }

    void removeIf(Predicate1<FieldDescr> p) {
	for (ListIterator<FieldDescr> i = fields.listIterator()
		 ; i.hasNext();) {
	    FieldDescr fd = i.next();
	    if (p.trueOf(fd)) {
		i.remove();
		javaNameToField.remove(fd.getName());
		externalNameToField.remove(fd.getExternalName());
	    }
	}
    }

}
