/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Apr  1 22:05:42 2003 by Jeff Dalton
 */

package ix.util.lisp;

import java.util.*;

import ix.util.*;

/** Symbols used in patterns as variables that match a single object. */

public class ItemVar extends Symbol {

    protected ItemVar(String name) {
	super(name);
    }

    /** 
     * Returns a copy of the tree in which every ItemVar is replaced
     * by an ItemVar that did not exist before this call to this method.
     */
    public static Object renameItemVars(Object tree) {
	return renameItemVars(new HashMap(), tree);
    }

    // We have our own generator in case the default one is
    // generating long, "unique" ids.
    protected static Gensym.Generator varGen = new Gensym.Generator();

    protected static Object renameItemVars(HashMap map, Object tree) {
	if (tree instanceof ItemVar) {
	    ItemVar var = (ItemVar)tree;
	    ItemVar newVar = (ItemVar)map.get(var);
	    if (newVar == null) {
		newVar = (ItemVar)varGen.nextNewSymbol(var.toString());
		map.put(var, newVar);
	    }
	    return newVar;
	}
	else if (tree instanceof Cons) {
	    Cons t = (Cons)tree;
	    return new Cons(renameItemVars(map, t.car()), 
			    (LList)renameItemVars(map, t.cdr()));
	}
	else
	    return tree;
    }

}
