/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Sep  1 17:50:43 2003 by Jeff Dalton
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.util.ipc;

import ix.util.*;

/**
 * A communication strategy that can be given parameters that are
 * usually the names of other communication strategies or communication
 * strategy expressions.
 *
 * @see IPC#evalStrategyExpr(String)
 */
public interface ParameterizedCommStrategy extends IPC.CommunicationStrategy {

    /**
     * Process the arguments in whatever way is appropriate.
     * The result is normally the same communication strategy,
     * after whatever changes are caused by processing the
     * arguments.
     */
    public IPC.CommunicationStrategy apply(String[] args);

}
