/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Apr 23 16:15:27 2008 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2008, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * A context-holding strategy that associates context-holders with
 * threads, with inheritance from the parent thread.  Although the
 * holder for a thread is inherited from the thread's parent, it
 * may be explicitly set to a different value.
 */
public class InheritableThreadLocalHoldingStrategy
       extends ThreadLocalHoldingStrategy {

    public InheritableThreadLocalHoldingStrategy() {
	threadContextHolder = new InheritableThreadLocal<ContextHolder>() {
	    protected ContextHolder initialValue() {
		return initialHolder();
	    }
	};
    }


    /**
     * Called to create a holder for a thread that doesn't already have one.
     * Unless overridden in a subclass, this method returns an instance of
     * {@link SynchronizedContextHolder}.
     */
    @Override
    protected ContextHolder initialHolder() {
	return new SynchronizedContextHolder();
    }

}
