/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Oct  2 22:20:19 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

import ix.util.*;

/**
 * Maps a key to a context-dependent list.  Note that the mapping
 * is not itself context-dependent -- a given key maps to the same
 * list regardless of context -- but what the list contains is
 * context-dependent.
 *
 * @see LLQueue
 */
public class ContextMultiHashMap extends MultiHashMap
       implements ContextMultiMap {

    public Object put(Object key, Object value) {
	throw new UnsupportedOperationException();
    }

    public Collection makeValueCollection(Object firstItem) {
	Collection c = new LLQueue();
	c.add(firstItem);
	return c;
    }

    public void clearCompletely() {
	super.clear();
    }

    public void clear() {
	for (Iterator i = values().iterator(); i.hasNext();) {
	    LLQueue v = (LLQueue)i.next();
	    v.clear();
	}
    }

}
