/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 24 15:16:49 2008 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2008, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent int value.
 */
public class ContextInt extends ContextValue<Integer> {

    public ContextInt(int rootValue) {
	super(rootValue);
    }

    public ContextInt(ContextHolder holder, int rootValue) {
	super(holder, rootValue);
    }

    /** Increment by the indicated amount, then return the new value. */
    public int add(int incr) {
	int i = get() + incr;
	set(i);
	return i;
    }

    /** Increment then return the new value.  Like <tt>++i</tt>. */
    public int incrBefore() {
	int i = get() + 1;
	set(i);
	return i;
    }

    /** Increment then return the old value.  Like <tt>i++</ii>. */
    public int incrAfter() {
	int i = get();
	set(i + 1);
	return i;
    }

}
