/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Jan 19 18:19:33 2004 by Jeff Dalton
 * Copyright: (c) 2001, 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that provides context-holders.
 *
 * @see Context
 */
public abstract class ContextHoldingStrategy {

    /**
     * Returns an appropriate context-holder.
     */
    public abstract ContextHolder getContextHolder();

    /**
     * Changes the context-holder that would be returned, if that
     * makes sense.  (Optional operation.)
     *
     * @throws UnsupportedOperationException if the
     *         <code>setContextHolder</code> method is not supported.
     */
    public void setContextHolder(ContextHolder h) {
	throw new UnsupportedOperationException("can't set context-holder");
    }

    /**
     * Tells any ContextHolders it knows about to set their current
     * context to the root context.  
     * Called by {@link Context#clearContexts()}.
     */
    public abstract void clearContexts();

}
