/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sat Feb 21 19:05:19 2004 by Jeff Dalton
 * Copyright: (c) 2004, AIAI, University of Edinburgh
 */

package ix.util.context;

import ix.util.ConsistencyException;

/**
 * Thrown when the current context is not what it should be.
 * For example, if an iterator for a context-dependent collection
 * is created when the current context is C, the context should
 * still be C when the iterator is used.
 */
public class ContextChangeException extends ConsistencyException {

    public ContextChangeException() {
	super();
    }

    public ContextChangeException(String message) {
	super(message);
    }

    public ContextChangeException(String message, Object culprit) {
	super(message, culprit);
    }

}
