/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Apr 24 15:13:55 2008 by Jeff Dalton
 * Copyright: (c) 2001, 2004, 2008, AIAI, University of Edinburgh
 */

package ix.util.context;

import java.util.*;

/**
 * An object that contains a single context-dependent boolean value.
 */
public class ContextBoolean extends ContextValue<Boolean> {

    public ContextBoolean(boolean rootValue) {
	super(rootValue);
    }

    public ContextBoolean(ContextHolder holder, boolean rootValue) {
	super(holder, rootValue);
    }

    public boolean isTrue() {
	return Context.getInContext(link, holder.getContext())
	           .booleanValue();
    }

    public boolean isFalse() {
	return ! Context.getInContext(link, holder.getContext())
	             .booleanValue();
    }

}
