/* Author: Jeff Dalton
 * Updated: Thu May 22 13:54:26 2008 by Jeff Dalton
 * Copyright: (c) 2000, 2001, 2008, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;

public class TwoKeyHashMap<K1,K2,V> extends HashMap<Object,V> {

    public TwoKeyHashMap() { }

    public void put(K1 key1, K2 key2, V value) {
	super.put(combineKeys(key1, key2), value);
    }

    public V get(K1 key1, K2 key2) {
	return super.get(combineKeys(key1, key2));
    }

    public Object combineKeys(K1 key1, K2 key2) {
	return ix.util.lisp.Lisp.list(key1, key2);
    }

}
