/* File: MessageQueue.java
 * Contains: A class for thread communication
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: January 1998
 * Updated: Mon Aug  4 16:07:21 2003 by Jeff Dalton
 * Copyright: (c) 1998, 2003, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.*;


/**
 * A queue for messages between threads.
 */

public class MessageQueue {

    List contents = new LinkedList();

    boolean returnInterrupts = false; // good idea or bad? Throw instead? /\/

    public MessageQueue() {
	this(false);
    }

    public MessageQueue(boolean returnInterrupts) {
	super();
	this.returnInterrupts = returnInterrupts;
    }

    public synchronized void send(Object message) {
	contents.add(message);
	// Optimization: notify only if (contents.size() == 1) // if was empty
	notifyAll();
    }

    public synchronized void sendIfNew(Object message) {
	if (!contents.contains(message)) {
	    contents.add(message);
	    notifyAll();
	}
    }

    public synchronized void push(Object message) {
	contents.add(0, message);
	notifyAll();
    }

    public synchronized Object nextMessage() {
	while (contents.isEmpty()) {
	    try { wait(); }
	    catch (InterruptedException e) {
		if (returnInterrupts)
		    return e;
	    }
	}
	return contents.remove(0);
    }

    public synchronized boolean waitForMessage() {
	// Returns true if there's a message, false if not.
	if (contents.isEmpty()) {
	    try { wait(); }
	    catch (InterruptedException e) {}
	}
	return !contents.isEmpty();
    }

    public synchronized boolean waitForMessage(long timeout) {
	// Returns true if there's a message, false if not.
	if (contents.isEmpty()) {
	    try { wait(timeout); }
	    catch (InterruptedException e) {}
	}
	return !contents.isEmpty();
    }

    public synchronized boolean hasMessage() {
	return !contents.isEmpty();
    }

    public synchronized void callOnContents(Proc p) {
	// Lets us do things inside the synchronization.
	p.call(contents);
    }

    public synchronized void clear() {
	contents.clear();
    }

}
