/* File: Mark.java
 * Contains: A class for simple objects that can be used as marks.
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: March 1998
 * Updated: Tue Feb  5 03:32:26 2002 by Jeff Dalton
 * Copyright: (c) 1998, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * A class used when marking objects as used, visited, etc.  An algorithm
 * can create a Mark that is new and hence not == to any Marks created
 * earlier.  The new Mark can then be used to mark objects as they are
 * vistied (or whatever).  Although Marks are meant to be distinguished
 * by object-identity alone (ie, by ==), they contain some fields for
 * debugging purposes: a String that names the algorithm that created
 * the mark, and a long for tellng Marks apart "visually" (e.g. if they're
 * printed).
 *
 * @see Markable
 */

public class Mark {

    static long count = 0;

    String createdBy;
    long number;
	
    public Mark(String createdBy) {
	this.createdBy = createdBy;
	this.number = (count++);
    }
    
}
