/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Jun 17 17:44:07 2008 by Jeff Dalton
 * Copyright: (c) 2005 - 2008, AIAI, University of Edinburgh
 */

package ix.util;

/**
 * Very simple arithmetic with a pretend positive infinity.
 */
public final class Inf {

    private Inf() { }		// block instantiation

    public static final long INFINITY = Long.MAX_VALUE;

    public static boolean isLess(long i, long j) {
	return i < j;		// depends on infinity being Long.MAX_VALUE
    }

    public static long add(long i, long j) {
	return (i == INFINITY || j == INFINITY) ? INFINITY : i + j;
    }

    public static long diff(long i, long j) { // i - j
	if (i == INFINITY) return INFINITY;
	else if (j == INFINITY)
	    throw new IllegalArgumentException
		("Cannot subtract infinity from " + i);
	else return i - j;
    }

    public static boolean isInfName(Object o) {
	return "inf".equalsIgnoreCase(o.toString());
    }

    public static String asString(long i) {
	return i == INFINITY ? "inf" : i + "";
    }

    public static String asString(Long i) {
	return asString(i.longValue());
    }

}
