/* File: Collector.java
 * Contains: An interface for Objects that can collect Objects and enum them.
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: March 1998
 * Updated: Mon May 28 00:15:55 2001 by Jeff Dalton
 * Copyright: (c) 1998, AIAI, University of Edinburgh
 */

package ix.util;

import java.util.Enumeration;

/**
 * A Collector can be given new elements and can return the "result"
 * derived from those elements.  For example, if the elements
 * are numbers, the result might be their sum. <p>
 *
 * The name "Collector" was chosen to avoid taking "Collection",
 * and hence to avoid conflicts with various collection packages.
 *
 * @see ix.util.lisp.LListCollector
 */

public interface Collector {

    public void addElement(Object e);

    public Object result();

}
