/* File: AssertionFailure.java
 * Contains: An exception class for indicating false assertions
 * Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Created: January 1998
 * Updated: Mon Feb 17 16:54:54 2003 by Jeff Dalton
 * Copyright: (c) 1998, AIAI, University of Edinburgh
 */

package ix.util;


/** The exception thrown by Debug.expect when an assertion is false. <p>

  AssertionFailure is a RuntimeException and so does not need to be
  listed in the "throws" clauses of method definitions.  One reason
  for that is to avoid discouraging the use of assertions.  If
  AssertionFailure had to be declared, then adding an assertion
  in a method that had none before would require nonlocal changes
  in the code.

  @see Debug#expect(boolean)

 */

public class AssertionFailure extends ConsistencyException {

    AssertionFailure() {
	super();
    }

    AssertionFailure(String m) {
	super(m);
    }

}

// Issues:
// * Perhaps it should extend Error instead; but too much code
//   code catches Exceptions but not Errors.
