/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Sep 25 17:55:14 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.icore.*;
import ix.ip2.test.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

public class TestGen extends TestSequenceGenerator {

    protected List delays;

    public TestGen() {
    }

    public List getDelays() { return delays; }

    public void setDelays(List delays) { this.delays = delays; }

    public TestSequence generateTestSequence() {
	if (delays == null)
	    return super.generateTestSequence();

	TestSequence seq = new TestSequence();
	List items = new LinkedList();

	for (Iterator i = delays.iterator(); i.hasNext();) {
	    int delay = ((Number)i.next()).intValue();
	    TestItem item = copyTemplate();
	    item.setDelayBefore(delay);
	    items.add(item);
	}
	
	seq.setMenuText(menuText);
	seq.setTestItems(items);
	Debug.noteln("Generated sequence:", XML.objectToXMLString(seq));
	return seq;

    }

}
