/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Feb 16 01:11:39 2006 by Jeff Dalton
 * Copyright: (c) 2005 - 2006, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.io.Serializable;
import java.io.StringReader;

import ix.iscript.IScriptSource;

import ix.util.*;
import ix.util.lisp.*;

/**
 * Allows Lisp source code to be written in XML using the ordinary
 * textual syntax.  For example:
 * <pre>
 *   &lt;lisp-source-text&gt;
 *     (defun f (x) (* x x))
 *     (defun g (x y) (/ (+ x y) 2))
 *   &lt;/lisp-source-text&gt;
 * </pre>
 *
 * @see LispProgramReader
 */
public class LispSourceText implements SemiPrimitive, Serializable,
				       ProgramSource, IScriptSource {

    // /\/: What if the source needs an unusual parser?
    protected static LispInterpreter parser = new LispInterpreter();

    protected String text = "";

    public LispSourceText(String text) {
	this.text = text;
    }

    public static Object valueOf(String text) {
	return new LispSourceText(text);
    }

    public String toString() {
	return text;
    }

    public boolean equals(Object obj) {
	return obj instanceof LispSourceText
	    && ((LispSourceText)obj).text.equals(text);
    }

    public String getSyntax() {	// IScriptSource interface
	return "iscript/lisp";
    }

    public Interpreter.Expr parseSource() { // IScriptSource interface
	LList source = readSource();
	return parser.parseForm(new Cons(parser.PROGN, source));
    }

    public String getLanguage() { // ProgramSource interface
	return "iscript/lisp";
    }

    public Object getSource() {	// ProgramSource interface
	return readSource();
    }

    public LList readSource() {
	LListCollector col = new LListCollector();
	LispReader r = new LispProgramReader(new StringReader(text));
	Object in;
	while ((in = r.readObject()) != Lisp.EOF) {
	    col.add(in);
	}
	return col.contents();
    }

}
