/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 18 22:25:05 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.test.xml;

import java.util.*;

import ix.util.*;
import ix.util.reflect.ElementClass;

/**
 * Example of how to define a class whose instances can be translated
 * to and from XML using the I-X XML utilities.
 */
public class Example {

    private String name;

    private int size;

    private @ElementClass(String.class) List<String> friends;

    private List<Example> children;

    public Example() {
    }

    public String getName() {
	return name;
    }

    public void setName(String n) {
	this.name = n;
    }

    public int getSize() {
	return size;
    }

    public void setSize(int s) {
	this.size = s;
    }

    public List<String> getFriends() {
	return friends;
    }

    public void setFriends(List<String> fs) {
	this.friends = fs;
    }

    public List<Example> getChildren() {
	return children;
    }

    public void setChildren(List<Example> cs) {
	this.children = cs;
    }

}
