/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Fri May 30 15:12:34 2008 by Jeff Dalton
 * Copyright: (c) 2008, AIAI, University of Edinburgh
 */

package ix.test;

import javax.xml.XMLConstants;

import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import java.util.*;

import ix.util.*;
import ix.util.xml.XML;

/**
 * Uses the XML validation facilities in Java to validate XML
 * using an XML or Relax NG schema.
 */

public class ValidateXml {

    public static void main(String[] argv) {
	if (argv.length < 2) {
	    System.out.println
		("Usage: validate-xml SCHEMA DOC");
	    System.exit(1);
	}
	String schemaName = argv[0];
	String xmlFileName = argv[1];
	Schema schema = makeSchema(schemaName);
	Validator validator = schema.newValidator();
	try {
	    validator.validate(new StreamSource(xmlFileName));
	}
	catch (Exception e) {
	    System.out.println(Debug.describeException(e));
	}
    }

    static Schema makeSchema(String schemaName) {
	String schemaType = Strings.afterLast(".", schemaName);
	String schemaLanguage =
	      schemaType.equals("xsd") ? XMLConstants.W3C_XML_SCHEMA_NS_URI
	    : schemaType.equals("rng") ? XMLConstants.RELAXNG_NS_URI
	    : null;
	if (schemaLanguage == null) {
	    System.out.println
		("Could not determine schema language for " + schemaName);
	    System.exit(2);
	}
	try {
	    return SchemaFactory.newInstance(schemaLanguage)
	               .newSchema(XML.toURL(schemaName));
	}
	catch (SAXException e) {
	    throw new RethrownException(e);
	}
    }

}

