/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Oct 26 14:06:13 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.net.*;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

import ix.ip2.*;

// import ix.iplan.*;

import ix.util.*;

/**
 * Test starting two I-P2s in the same JVM.
 */
public class TwoIp2Test {

    static URL ixJar =
	TwoIp2Test.class.getClassLoader().getResource("ix.jar");    

    public static void main(String[] argv) throws Exception {
// 	Util.printGreeting("Two I-P2 Test");
// 	new Ip2(true).mainStartup(argv);
// 	new Ip2(false).mainStartup(argv);

	if (ixJar == null)
	    throw new IllegalStateException("Can't find ix.jar");

	startSeparateAgent("ix.ip2.Ip2", argv);
	startSeparateAgent("ix.ip2.Ip2", argv);

    }

    static void startSeparateAgent(String className, String[] argv)
           throws Exception {
	URL[] urls = new URL[]{ixJar};
	ClassLoader loader = new AgentClassLoader(urls);
	// System.out.println("Loading " + className + " using " + loader);
	Class c = loader.loadClass(className);
	// System.out.println(c + " class loader = " + c.getClassLoader());
	Class[] sig = new Class[] { argv.getClass() };
	Method m = c.getMethod("main", sig);
	m.invoke(null, new Object[] { argv });
    }

    static class AgentClassLoader extends URLClassLoader {

	AgentClassLoader(URL[] urls) {
	    super(urls);
	}
	
	public Class loadClass(String name) throws ClassNotFoundException {
	    return loadClass(name, false);
	}

	protected Class loadClass(String name, boolean resolve)
	          throws ClassNotFoundException {
	    // System.out.println("Trying class " + name);
	    if (!name.startsWith("ix."))
		return super.loadClass(name, resolve);
	    // System.out.println("Loading class " + name);
	    Class c = findLoadedClass(name);
	    if (c == null)
		c = findClass(name);
	    if (resolve)
		resolveClass(c);
	    return c;
	}

    }

}

