/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 29 02:21:07 2007 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2007, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.PrintStream;

import java.util.*;

import ix.ip2.Ip2XMLConfig;
import ix.util.*;
import ix.util.xml.*;

public class TranslateFile {

    static FileSyntaxManager fsm = new Ip2XMLConfig().makeFileSyntaxManager();

    public static void main(String[] argv) {
	Debug.off();
	Parameters.setIsInteractive(false);
	if (argv.length > 0 && argv[0].equals("-help")) {
	    printHelp(System.out);
	    System.exit(0);
	}
	else if (argv.length < 2) {
	    System.err.println("Usage: translate-file filename ... type");
	    System.exit(1);
	}
	String type = argv[argv.length - 1];
	for (int i = 0; i < argv.length - 1; i++) {
	    translateFile(argv[i], type);
	}
    }

    static void printHelp(PrintStream out) {
	List help = new LinkedList();
	fsm.addAboutInfo(help);
	out.println(Strings.joinLines(help));
    }

    static void translateFile(String fileName, String toType) {
	System.out.println("Translating " + fileName);
	String outName = fsm.getExceptType(fileName) + "." + toType;
	FileSyntax outSyntax = fsm.getSyntax(outName);
	Object obj = fsm.readObject(Object.class, fileName);
	if (fsm.canWrite(outSyntax, obj.getClass()))
	    fsm.writeObject(obj, outName);
	else
	    System.err.println
		("Can't translate a " + XML.nameForClass(obj.getClass()) +
		 " as a file of type " + Strings.quote(toType));
    }

}

