/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu Jun 29 16:53:47 2006 by Jeff Dalton
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.test;

import java.io.*;
import java.util.*;

import ix.ip2.*;
import ix.iplan.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.plan.Plan;
import ix.icore.domain.*;

import ix.iface.util.KeyValueTable; // for a comparator

import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.MatchEnv;

public class SimpleExpandingSimulator extends Ip2 {

    protected PrintStream traceOut = Debug.out;

    protected boolean trace = true;

    public SimpleExpandingSimulator() {
	this(true);
    }

    protected SimpleExpandingSimulator(boolean setAgent) {
	super(setAgent);
	agentTypeName = "Simple I-Sim";
	logoLine1 = "Simple I-Sim";
	displayName = agentTypeName;
    }

    public static void main(String[] argv) {
	Util.printGreeting("Simple Expanding Simulator");
	SimpleExpandingSimulator sim = new SimpleExpandingSimulator();
	sim.mainStartup(argv);
	while (true) {
	    // Thread.yield();
	    sim.getPatternsAndRun();
	}
    }

    public void completeStartup() {
        super.completeStartup();
    }

    public SimController getSimController() {
	return (SimController)getController();
    }

    protected PanelController makeController() {
	return new SimController(this);
    }

    protected static class SimController extends PanelController {

	SimpleExpandingSimulator sim;

	SimController(SimpleExpandingSimulator sim) {
	    super(sim);
	    this.sim = sim;
	}

	public List addActivities(List activities) {
	    List result = new LinkedList();
	    for (Iterator i = activities.iterator(); i.hasNext();) {
		result.add(addActivity((Activity)i.next()));
	    }
	    return result;
	}

	public void execute(ActivityItem item) {
	    Debug.noteln("Trying to execute", item);
	    HandlerAction act = null;
	    for (Iterator i = item.getActions().iterator(); i.hasNext();) {
		HandlerAction a = (HandlerAction)i.next();
		if (item.actionCanBeTakenNow(a)) {
		    if (a instanceof HandlerAction.NoAction)
			continue;
		    else if (act == null)
			act = a;
		    else if (a instanceof ExpandHandler.ExpandAction) {
			if (act instanceof ExpandHandler.ExpandAction)
			    throw new IllegalStateException
				("More than one way to expand " + item);
			else
			    act = a;
		    }
		    else {
			// We have more than one non-expand way
			// to handle the activity.  /\/: For now,
			// just keep the first.
		    }
		}
	    }
	    if (act == null)
		throw new IllegalStateException("Cannot execute " + item);
	    getActivityAgenda().handleItem(item, act);
	}
    }

    protected void addHandlers() {

	// Handler that lets the user do nothing or make items complete.
	controller
//  	    .addItemHandler(new SimpleCompletionHandler());
	    .addItemHandler(new CompletionHandler(this));


	// Expansion
	controller
	    .addActivityHandler(new ExpandHandler(this));

	// Show URL
	controller
	    .addActivityHandler(new ShowURLHandler(this));

    }

    /* *** Testing *** */

    void getPatternsAndRun() {

	System.out.println
	    ("\nEnter patterns one per line ending with a blank line.");
	List patterns = new LinkedList();
	while (true) {
	    String line = Util.askLine(">").trim();
	    if (line.equals(""))
		break;
	    patterns.add(Lisp.elementsFromString(line));
	}

	simulateExecution(patterns);

    }

    synchronized void simulateExecution(List patterns) {
	List activities = new LinkedList();
	for (Iterator i = patterns.iterator(); i.hasNext();) {
	    LList p = (LList)i.next();
	    activities.add(new Activity(p));
	}
	List items = getSimController().addActivities(activities);
	for (Iterator j = items.iterator(); j.hasNext(); ) {
	    ActivityItem item = (ActivityItem)j.next();
	    getSimController().execute(item);
	}
    }

}
