/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May 27 18:25:49 2008 by Jeff Dalton
 * Copyright: (c) 2004, 2005, 2007, 2008, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.*;
import ix.icore.domain.*;

import ix.iview.SimpleDomainEditor;

import ix.util.*;
import ix.util.lisp.*;
import ix.util.xml.*;

/**
 * A classe for running block-stacking planning problems that use
 * precondition-satisfaction.
 */
public class PrecondBlockStacker extends BlockStacker {

    public PrecondBlockStacker(String problem) {
	super(problem);
    }

    @Override
    protected String getDefaultBaseDomainName() {
	return "test-domains/blocks-using-achieve-1.lsp";
    }

    public static void main(String[] argv) {
	Parameters.processCommandLineArguments(argv);
	String outFile = Parameters.getParameter("output");
	String problem = Parameters.getParameter("problem");
	Debug.expect(problem != null, "No problem specified");
	BlockStacker stacker = new PrecondBlockStacker(problem);
	stacker.findPlan();
	while (true) {
	    stacker.checkPlan();
	    if (outFile != null) {
		XML.writeObject(stacker.getPlan(), outFile);
	    }
	    if (Util.askLine("Replan?").trim().startsWith("y"))
		stacker.replan();
	    else
		System.exit(0);
	}
    }

    @Override
    protected Refinement initialStateRefinement(List initialTowers) {
	Refinement r = super.initialStateRefinement(initialTowers);
	r.setAnnotation(Symbol.intern("use-for-world-state-effects"),
			Symbol.intern(":none"));
	return r;
    }

    @Override
    protected Refinement goalStateRefinement(List finalTowers) {
	boolean useCondTypes = slip.domainUsesConditionTypes(baseDomain);
	Refinement r = new Refinement("problem-goal",
				      pattern("(problem-goal)"));
	// For each tower, (ON ...) preconditions that construct it.
	ListOfConstraint constraints = new LinkedListOfConstraint();
	for (Iterator i = finalTowers.iterator(); i.hasNext();) {
	    List tower = (List)i.next();
	    List onPatterns = towerPatterns(tower);
	    Collections.reverse(onPatterns);
	    for (Iterator j = onPatterns.iterator(); j.hasNext();) {
		LList onPat = (LList)j.next();
		Constraint cond =
		    new Constraint("world-state",
				   "condition",
				   Lisp.list(new PatternAssignment(onPat)));
		if (useCondTypes)
		    cond.setAnnotation(slip.S_CONDITION_TYPE, slip.S_ACHIEVE);
		constraints.add(cond);
	    }
	}
	r.setConstraints(constraints);
	return r;
    }

}
