/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue May  5 17:53:06 2009 by Jeff Dalton
 * Copyright: (c) 2009, AIAI, University of Edinburgh
 */

package ix.test;

import org.jdom.Document;

import java.net.*;
import java.io.*;
import java.text.*;
import java.util.*;

import ix.util.*;
import ix.util.xml.*;

/**
 * Tests HTTP "GET" requests that obtain XML.
 */
public class HttpGetDocumentTest {

    static final String dateTimePattern = "yyyy'-'MM'-'dd'T'HH'-'mm'-'ss'Z'";

    static final SimpleDateFormat format =
        new SimpleDateFormat(dateTimePattern);
    {
	format.setTimeZone(TimeZone.getTimeZone("GMT"));
	format.setLenient(false);
    }

    public static void main(String[] argv) {

        try {
            String url = argv[0];
            Document doc = XML.parseXML(XML.toURL(url));
            XML.makePrettyXMLOutputter().output(doc, System.out); // throws /\/
        }
        catch (Exception e) {
            Debug.noteException(e);
            writeErrorReport(e);
        }

    }

    static void writeErrorReport(Exception e) {
        Date now = new Date();
        String fileName = "http-get-error-" + format.format(now) + ".txt";
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fileName));
            e.printStackTrace(out);
            out.close();
        }
        catch (Exception grrr) {
            Debug.noteln("Cannot write error report");
            Debug.noteException(grrr);
        }
    }

}
