/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Aug 31 18:34:48 2003 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.*;
import ix.util.ipc.WrapperStrategy;
import ix.util.*;

public class FilterStrategy extends WrapperStrategy {

    public FilterStrategy() {
	super();
    }

    public void sendObject(Object destination, Object contents) {
	if (shouldSend(destination, contents))
	    super.sendObject(destination, contents);
	else {
	    Debug.noteln("Filter stops sending", contents);
	    Debug.noteln("   to", destination);
	}
    }

    public boolean shouldSend(Object destination, Object contents) {
	if (contents instanceof Report) {
	    return shouldSendReport((Report)contents);
	}
	else
	    return true;
    }

    public boolean shouldSendReport(Report report) {
	return report.getRef() == null;
    }

}
