/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Mon Aug 29 17:26:40 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.test;

import java.util.*;

import ix.icore.domain.Domain;

import ix.util.*;
import ix.util.xml.*;

/**
 * Checks all domains given as command-line arguments.
 */
public class CheckDomains {

    static String DASHES = Strings.repeat(30, " -");

    CheckDomains() {
    }

    public static void main(String[] argv) {
	Debug.off();
	Parameters.setIsInteractive(false);
	CheckDomains checker = new CheckDomains();

	Debug.noteln("XML Config:", XML.config());

	for (int i = 0; i < argv.length; i++) {
	    String name = argv[i];
	    checker.check(name);
	}
    }

    void check(String name) {
	traceln("");
	traceln(DASHES);
	traceln(name + ":");
	traceln("");
	Domain dom = null;
	try {
	    // dom = (Domain)XML.readObject(Domain.class, name);
	    Object obj = XML.readObject(name);
	    if (obj instanceof Domain)
		dom = (Domain)obj;
	    else {
		traceln("Not a domain.");
		return;
	    }
	}
	catch(Exception e) {
	    traceln("Cannot read a domain from " + name + ".  " +
		    Debug.describeException(e));
	    return;
	}
	try {
	    dom.checkConsistency();
	}
	catch (Exception e) {
	    traceln("Failed consistency check.");
	    traceln("");
	    traceln(Debug.foldException(e));
	}
    }

    void traceln(String line) {
	System.out.println(line);
    }

}
