/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed May 17 12:30:08 2006 by Jeff Dalton
 * Copyright: (c) 2003, 2006, AIAI, University of Edinburgh
 */

package ix.itest;

import javax.swing.*;
import java.util.*;

import ix.icore.IXAgent;

import ix.iface.util.ComboChoice;

import ix.ispace.AgentData;
import ix.ispace.event.*;

import ix.util.*;

public class DestinationChoice extends ComboChoice implements ContactListener {

    public DestinationChoice(IXAgent agent, Object[] specialItems) {
	this(agent, new DefaultComboBoxModel(specialItems));
    }

    public DestinationChoice(IXAgent agent, ComboBoxModel model) {
	super(model);
	agent.getContactManager().addContactListener(this);

	// Add all currently known agent names.
//  	List names = agent.getContactManager().getSortedNameList();
//  	for (Iterator i = names.iterator(); i.hasNext();) {
//  	    String name = (String)i.next();
//  	    addItem(name);
//  	}
    }

    public void contactChange(ContactEvent e) {
	if (e.isDeletion()) {
	    AgentData data = e.getOldData();
	    removeItem(data.getName());
	}
	else {
	    // Remember the name of any agent that sent to us.
	    AgentData data = e.getNewData();
	    String sender = data.getName();
	    if (!hasItem(sender)) {
		Debug.noteln("New contact", sender);
		addItem(sender);
	    }
	}
    }

}
