/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Thu May 30 03:19:37 2002 by Jeff Dalton
 * Copyright: (c) 2002, AIAI, University of Edinburgh
 */

package ix.ispace;

import java.util.*;

/**
 * Represents a collection of agents that cen be referred to for
 * message-sending or other purposes.
 */
public interface AgentGroup {

    /**
     * Returns the name of this AgentGroup.
     */
    public String getName();

    /**
     * Returns the collection of AgendData objects that represents
     * the currently known members of this group.  If the membership
     * is dynamic, this method should return a "snapshot" rather than
     * a collection that will change as the membership changes.
     * It should always return a (possibly empty) collection object,
     * never <code>null</code>.
     *
     * @see AgentData
     */
    public Collection getKnownMembers();

}
