/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.isim.actions;

import java.util.Iterator;
import java.util.*;
import ix.icore.domain.PatternAssignment;
import ix.icore.Sendable;
import ix.icore.domain.Constraint;
import ix.isim.ExecutableAction;
import ix.isim.SimulationException;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;

public class SendConstraint extends ExecutableAction {

    final static Symbol sendConstraintSy = Symbol.intern("send-constraint");
    final static Symbol worldStateSy = Symbol.intern("world-state");
    final static Symbol effectSy = Symbol.intern("effect");

    public SendConstraint() {
        super();
    }

    public void executeAction(MatchEnv env) throws SimulationException {
        // make sure the activity has the correct verb:
        if (!action.getActivity().getVerb().equals(sendConstraintSy)) {
            throw new SimulationException(
                    "Activity verb must be " + sendConstraintSy +
                    ", not " + action.getActivity().getVerb());
        }
        // send the message:
        Iterator elti = action.getActivity().getParameters().iterator();
        Name sender = Name.valueOf(elti.next());
        String recipient = elti.next().toString();
        LList constraint = (LList) elti.next();
        if ((!worldStateSy.equals(constraint.get(0))) ||
            (!effectSy.equals(constraint.get(1)))) {
            throw new SimulationException("Constraint must world-state effect!");
        }
        List params = new LinkedList();
        params.add(new PatternAssignment(
                (LList) constraint.get(2),
                constraint.get(4)));
        Sendable message = new Constraint(worldStateSy, effectSy, params);
        message.setSenderId(sender);
        // the actual sending of the message:
        try {
            IPC.getCommunicationStrategy().sendObject(recipient, message);
        } catch (Exception e) {
            throw new SimulationException("Unable to send message.");
        }
    }
}
