/* Author: Gerhard Wickler <g.wickler@ed.ac.uk>
 * Copyright: (c) 2006, AIAI, University of Edinburgh
 */

package ix.isim.actions;

import java.util.Iterator;

import ix.icore.Activity;
import ix.icore.Sendable;
import ix.isim.ExecutableAction;
import ix.isim.SimulationException;
import ix.util.IPC;
import ix.util.Name;
import ix.util.lisp.LList;
import ix.util.lisp.Symbol;
import ix.util.match.MatchEnv;

public class SendActivity extends ExecutableAction {

    final static Symbol sendActivitySy = Symbol.intern("send-activity");

    public SendActivity() {
        super();
    }

    public void executeAction(MatchEnv env) throws SimulationException {
        // make sure the activity has the correct verb:
        if (!action.getActivity().getVerb().equals(sendActivitySy)) {
            throw new SimulationException(
                    "Activity verb must be " + sendActivitySy +
                    ", not " + action.getActivity().getVerb());
        }
        // send the message:
        Iterator elti = action.getActivity().getParameters().iterator();
        Name sender = Name.valueOf(elti.next());
        String recipient = elti.next().toString();
        Sendable message = new Activity((LList) elti.next());
        message.setSenderId(sender);
        // the actual sending of the message:
        try {
            IPC.getCommunicationStrategy().sendObject(recipient, message);
        } catch (Exception e) {
            throw new SimulationException("Unable to send message.");
        }
    }
}
