/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Tue Aug 23 17:05:19 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iscript;

import java.util.*;

import ix.util.*;
import ix.util.lisp.Interpreter;

/**
 * An object that represents or contains I-Script source code.
 */
public interface IScriptSource {

    /**
     * Returns a string that identifies the syntax of the source
     * contained in, or represented by, this object.  At present,
     * the value should be either "iscript/lisp" or "iscript/xml".
     */
    public String getSyntax();

    /**
     * Converts the source code into the tree representation
     * used by {@link Interpreter}s.
     */
    public Interpreter.Expr parseSource();

}
