/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Aug 15 00:22:17 2007 by Jeff Dalton
 * Copyright: (c) 2007, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.util.xml.XML;

/**
 * Specifies a group of tests that can be applied to different domains.
 * If an instance of this class appears in a list of PlanTests given to
 * an {@link AutoTester}, the AutoTester will record the instance as
 * a group.  That happens via the TestRunner returned by the
 * {@link #makeTestRunner(AutoTester)} method.
 *
 * <p>Note that a PlanTestGroup is a PlanTest and so can be used
 * to provide default values to other PlanTests, typically to the
 * PlanTests in the group.  Indeed, that happens when the group
 * is used by an instance of {@link ExpandPlanTestGroup}.
 */
public class PlanTestGroup extends PlanTest {

    /** This group's name. */
    protected String name;

    /** The {@link PlanTest}s in this group. */
    protected List tests;

    public PlanTestGroup() {
        super();
    }

    public String getName() {
	return name;
    }

    public void setName(String name) {
	this.name = name;
    }

    public List getTests() {
	return tests;
    }

    public void setTests(List tests) {
	this.tests = tests;
    }

    /**
     * Returns a TestRunner that tells the AutoTester to remember
     * this group.
     *
     * @see AutoTester#definePlanTestGroup(PlanTestGroup)
     */
    public AutoTester.TestRunner makeTestRunner(final AutoTester auto) {
	return auto.new TestRunner(PlanTestGroup.this) {
	    public void runTest() {
		auto.definePlanTestGroup(PlanTestGroup.this);
	    }
	};
    }

    public String testDescription() {
	return "Group named " + name; // /\/
    }

}
