/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Wed Feb 16 03:26:55 2005 by Jeff Dalton
 * Copyright: (c) 2005, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.io.PrintStream;

/**
 * Statistics provided by a planning algorithm after it has been
 * asked to plan or replan.
 *
 * @see Planner
 */
public interface PlanStats {

    /**
     * Records a statistic.  The value is typically an Integer.
     * There is no requirement that planners record all statistics
     * using this method; it is public primarily so that things
     * that use a planner can add some statistics of their own.
     */
    public void recordStat(String key, Object value);

    /**
     * Increments, or otherwise modifies, the values in this object
     * using values from the specified PlanStats object.  A typical
     * use is to keep running totals, and it is required that
     * PlanStats objects returned from the same planner can be
     * used in that way.
     *
     * <p>The two PlanStats objects involved when this method is
     * called normally have to agree about value classes.
     * Different statistics may have different value classes.
     * Classes that implement PlanStats are free to combine the
     * values in any way they want, and for a numeric statistic,
     * the combined value does not have to be a straight sum.
     */
    public void addStats(PlanStats stats);

    /**
     * Prints a plain text description of the statistics and
     * their values.
     */
    public void report(PrintStream out);

}
