/* Author: Jeff Dalton <J.Dalton@ed.ac.uk>
 * Updated: Sun Jul 15 23:29:09 2007 by Jeff Dalton
 * Copyright: (c) 2004, 2007, AIAI, University of Edinburgh
 */

package ix.iplan;

import java.util.*;

import ix.ip2.*;
import ix.icore.*;
import ix.icore.process.*;
import ix.icore.plan.*;
import ix.icore.domain.*;
import ix.util.*;
import ix.util.lisp.*;
import ix.util.match.*;

public class IPlanModelManager extends Ip2ModelManager {

    private IPlanWorldStateManager worldCM;

    public IPlanModelManager(Ip2 ip2) {
	super(ip2);
    }

    @Override
    protected Ip2WorldStateManager makeWorldStateManager() {
	return worldCM = new IPlanWorldStateManager(this);
    }

    @Override
    protected void postProcessInstalledPlan(PlanInstaller pi) {
	// No nothing.  But override the inherited method,
	// because it does some things we don't want.
    }

    @Override
    protected void forcedBindings(MatchEnv forced) {
	// /\/: For now, at least, we want to tell the user,
	// but this class shouldn't be doing UI stuff.
	// /\/: But not in this MM because it's used by the automatic planner
// 	if (Parameters.isInteractive())
// 	    Util.displayAndWait(null,
// 	      Strings.foldLongLine("Discovered necessary bindings " + forced));
	bindVariables(forced);
    }

    void satisfyConds(PNode at, ListOfConstraint conds, MatchEnv env) {
	worldCM.satisfyConds(at, conds, env);
    }

    public void setWorldStateMap(Map desiredState) { // for Slip /\/
	Debug.noteln("Setting world state to", desiredState);
	Map now = getWorldStateMap();
	// First delete any patterns that are not in the desired state.
	for (Iterator i = now.entrySet().iterator(); i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    LList pat = (LList)e.getKey();
	    if (desiredState.get(pat) == null)
		deleteEffect(new PatternAssignment(e));
	}
	// Add any new patterns needed, and give any remaining
	// old patterns their desired values.
	handleEffects(PatternAssignment.mapToAssignments(desiredState));
    }

}
